/* $Id: machine.c,v 1.55 1999/01/20 03:04:03 ericb Exp $ */
/* Copyright (C) 1994 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Taken from E1431 library, heavily modified by Eric Backus */

/* Routines that are machine dependent */

#include "sema.h"

#if defined _WINDLL || defined _WIN32
#include <stdarg.h>
#endif

#ifdef _WINDLL 
#  include "windows.h"
#  include "windowsx.h"
#endif

#define MAX_LOGICAL_ADDRS	256

#ifdef HPVXI_DOWNLOAD
#define TICK_TIME .01    /* 10 mS per time "tick" */
#endif

/*
 *********************************************************************
 This turns the TRY-RECOVER mechanism on and off.
 *********************************************************************
 */
/*ARGSUSED*/
void EXPORT
e1432_set_try_recover(LONGSIZ32 state)
{
#ifdef	HAVE_SIGBUS
    struct sigvec vec;

    i1432_buserr_trap = state;

    if (state)
    {
	/* reestablish sig vector */
	vec.sv_handler = i1432_buserr_handler;
	vec.sv_mask = 0;

#ifdef E1485_SOURCE
	vec.sv_flags = SV_FLAGS_DEFAULT;
#else
	vec.sv_flags = 0;
#endif /* E1485_SOURCE */

	/* install bus error handler */
	(void) sigvector(SIGBUS, &vec, &vec);
    }
    else
    {
	/* remove sig vector */
	vec.sv_handler = 0;
	vec.sv_mask = 0;

#ifdef E1485_SOURCE
	vec.sv_flags = SV_FLAGS_DEFAULT;
#else
	vec.sv_flags = 0;
#endif /* E1485_SOURCE */

	/* install bus error handler */
	(void) sigvector(SIGBUS, &vec, &vec);
    }
#endif /* HAVE_SIGBUS */
}

/*
 *********************************************************************
 Gets the current time as a floating point number in seconds.
 *********************************************************************
 */
void
i1432_get_time(FLOATSIZ64 * secs)
{
#if (defined(_WINDLL)||defined(_WIN32))
    DWORD   msec;

    msec = GetTickCount();
    *secs = (FLOATSIZ64) msec * 0.001;
#else
#ifndef HPVXI_DOWNLOAD
    struct timeval tv;
    struct timezone tz;

    if (gettimeofday(&tv, &tz) != 0)
    {
	(void) i1432_print_error(ERR1432_SYSTEM_TIME);
	*secs = 0;
	return;
    }

    *secs = tv.tv_sec + 0.000001 * tv.tv_usec;
#else
    ULONGSIZ32 sec, usec;

    os_time(&sec, &usec);
    *secs = sec + 0.000001 * usec;
#endif
#endif
}

/*
 *********************************************************************
 Pause for <delay>, where <delay> is a floating point number in
 seconds.
 *********************************************************************
 */
void
i1432_pause(FLOATSIZ64 delay)
{
#ifndef	HPVXI_DOWNLOAD
    FLOATSIZ64 currentTime, startTime;

    i1432_get_time(&startTime);
    do
	i1432_get_time(&currentTime);
    while (currentTime - startTime < delay);
#else	/* HPVXI_DOWNLOAD */
    LONGSIZ32 ticks = (LONGSIZ32)(delay/TICK_TIME + .999);
    os_pause_p(ticks);
#endif	/* HPVXI_DOWNLOAD */
}

/*
 *********************************************************************
 Sets the interface name used by iopen
 *********************************************************************
 */
SHORTSIZ16 EXPORT
e1432_set_interface_addr(const char *name)
{
#if defined(HAVE_SICL) || defined(HAVE_VTL)
    (void) strncpy(i1432_sicl_name, name, E1432_SICL_NAME_MAX - 1);
#endif
    return 0;
}

#ifndef HAVE_VTL
/*
 *********************************************************************
 This routine performs any initialization needed on the I/O driver.
 *********************************************************************
 */
SHORTSIZ16 EXPORT
e1432_init_io_driver(void)
{
    SHORTSIZ16 error;
    int     i;

    /* If previously initialized, uninitialize, then reinitialize */
    if (i1432_lib_init)
	(void) e1432_uninit_io_driver();

#ifdef	HAVE_SICL
    if (strlen(i1432_sicl_name) == 0)
	/* Default to "vxi" if the user never called
	   e1432_set_interface_addr */
	(void) strcpy(i1432_sicl_name, "vxi");

    error = i1432_sicl_imap_init();
    if (error)
	return error;
#endif

#ifdef	HAVE_SIGBUS
    i1432_buserr_trap = 0;
    i1432_buserr_env_valid = 0;
#endif
    i1432_lib_init = 1;
    i1432_mod_list = 0;
    i1432_group_list = NULL;
    i1432_trace_level = 0;
    i1432_diag_print_level = 0;
    i1432_print_reg_access = 0;
    i1432_print_errors = 0;
    i1432_error_info = NULL;
    i1432_error_str = "";
    for (i = 0; i < E1432_CHAN_TYPES; i++)
	i1432_chan_list[i] = NULL;

    i1432_dnld_fw_state = 0;   /* substrate FW not downloaded */
    i1432_dnld_fw_err = 0;     /* no substrate FW download error */
    i1432_install_file = NULL; /* no download file selected */
    i1432_trigger_sent = 0;
    i1432_kludge_data_rpm_flag = 0;
    i1432_kludge_data_rpm_id1 = 0;
    i1432_kludge_data_rpm1 = 0;
    i1432_kludge_data_rpm2 = 0;
    i1432_kludge_enable_flag = 0;
    i1432_kludge_tach_flag = 0;
    i1432_rs_irq_error = 0;
    return 0;
}

SHORTSIZ16 EXPORT
e1432_uninit_io_driver(void)
{
    SHORTSIZ16 error;

    /* Free any memory in channel groups */
    error = e1432_delete_all_chan_groups(NULL);
    if (error)
	return error;

    /* Free any memory in channel and module lists, unmap imapped
       memory, close SICL device sessions. */
    error = e1432_assign_channel_numbers(0, NULL, NULL);
    if (error)
	return error;

#ifdef	HAVE_SICL
    error = i1432_sicl_imap_uninit();
    if (error)
	return error;

    /* I was going to reset i1432_sicl_name here, but I don't think we
       should because the user sets it before e1432_init_io_driver. */
#endif

    i1432_lib_init = 0;

    return 0;
}
#endif /* !HAVE_VTL */

/*
 *********************************************************************
 Tests to see if there is an semaphore module at this logical address.
 Returns 1 or 0.
 *********************************************************************
 */
SHORTSIZ16
i1432_sema_present(E1432_MODULE_LIST_NODE *mn)
{
    SHORTSIZ16 dtype, err;
    int     model;

    err = i1432_direct_read_register(mn, E1432_DEVICE_TYPE_REG, &dtype);
    if ( err )
    {
	DIAG_PRINTF(1, ("  An attempt to read the E1432 DEVICE TYPE register"
	  " failed\n"));
	if ( err == ERR1432_BUS_ERROR )
	{
	    DIAG_PRINTF(1, ("  in a bus error.  The ID register read OK.\n"));
	}
	else
	{
	    DIAG_PRINTF(1, ("  with error %d.  The ID register read OK.\n",
	      err));
	}
	DIAG_PRINTF(1, ("\n"));
	DIAG_PRINTF(1, ("  Suspect:  VXI interface U780, its ROM U707. \n"));
	return 0;
    }

    TRACE_PRINTF(4, ("i1432_sema_present: la %d, device type 0x%x "
		     "(semaphore is 0x%x - 0x%x)\n", mn->la, dtype,
		     E1432_MODEL_CODE_MIN, E1432_MODEL_CODE_MAX));
    model = dtype & DTYPE_MODEL_CODE_MASK;
    if (model >= E1432_MODEL_CODE_MIN &&
	model <= E1432_MODEL_CODE_MAX)
    {
	if ( (dtype & DTYPE_A24_MASK) == 0x5000 )
	{
	    mn->a24_256k = 1;
	    return 1;
	}
	else if ( (dtype & DTYPE_A24_MASK) == 0x3000 )
	{
	    mn->a24_256k = 0;
	    return 1;
	}
	else
	{
	    DIAG_PRINTF(1, ("  The E1432 DEVICE TYPE register returned the"
	      " wrong value\n"));
	    DIAG_PRINTF(1, ("  for A24 size.  Expected 0x3000 or 0x5000, got"
	      " 0x%4.4x\n", dtype & DTYPE_A24_MASK));
	    return 0;
	}
    }
    else
    {
	DIAG_PRINTF(1, ("  The E1432 DEVICE TYPE register returned the wrong"
	  " model code.\n"));
	DIAG_PRINTF(1, ("  Expected 0x%4.4x to 0x%4.4x,  got 0x%4.4x\n",
	  E1432_MODEL_CODE_MIN, E1432_MODEL_CODE_MAX, model));
	DIAG_PRINTF(1, ("\n"));
	DIAG_PRINTF(1, ("  Suspect:  VXI interface U780, its ROM U707. \n"));
	return 0;
    }
}



#if (defined _WINDLL || defined _WIN32) && !defined(HAVE_VTL)

/* optional handle to a Visual Basic multi-line text box control */
HWND diagHwndText = 0;
#define CLINESMAX 600   /* keep text box data < 65k bytes */

/*****************************************************************
 *  printf()
 *
 *  printf for embedding in DLLs.  directs output to debug window. 
 *  Start DBWIN.EXE before running a dll that uses this.
 ******************************************************************/

int __cdecl printf( const char *a, ...)
{   
#ifdef _WINDLL 
    if (diagHwndText)
    /* a VB test box is opened, use it */
    {
        va_list args_ptr;
        int chkLines;
        size_t nChars;
        char *s; 	/* temp pointer to buf */
        char *plf;  /* pointer to LF char in buf */
        const char szCrlf[] = { 0x0D, 0x0a, 0x00};
        char buf[255];

        /* do printf formatting by calling vsnprintf */   
        va_start( args_ptr, a );
        buf[254] = 0;    
        _vsnprintf( buf, 254, a, args_ptr);
        va_end (args_ptr);

	nChars = strlen( buf );
	if (nChars == 0)
	return 0;
	
	// First see if we will exceed our line maximum
	//
	chkLines = Edit_GetLineCount (diagHwndText);
	if (chkLines > CLINESMAX)
	{
	Edit_SetSel (diagHwndText, 0,
          Edit_LineIndex (diagHwndText, chkLines - CLINESMAX * 2 / 3));
	Edit_ReplaceSel (diagHwndText, "");
	}
	
	// Append to the end of the buffer.
	// This loop does a special insert for every line 
	// to get CR/LF right.
	// If there are any LFs without CRs, add CRs
	s = buf;                               
	while (s && strlen(s)) {
	    plf = strchr( s, 0x0A );
	    if (plf) {	/* if found a line feed */
	    	*plf = 0;	/* kill it */
	    	if (strlen(s) && (*(plf-1) == 0x0D))
	    		*(plf-1) = 0;	/* kill any CR before LF */
	    }
	    Edit_SetSel (diagHwndText, 32767, 32767);
	    Edit_ReplaceSel (diagHwndText, s );
	    if (plf) { /* need to insert CRLF */
	       Edit_SetSel (diagHwndText, 32767, 32767);
	       Edit_ReplaceSel (diagHwndText, szCrlf );
	    }                                     
	    /* move the pointer to the next line */
	    if (plf)
	    	s = plf + 1;
	    else
	    	s = 0;
	}
	Edit_SetSel (diagHwndText, 32767, 32767);
    }
    else
#endif /* _WINDL */
    /* default - use the Debug window */
    {
        if (strchr( a, '%')) {
            char s[255];
            va_list args_ptr;
        
            va_start( args_ptr, a );
            s[254] = 0;    
            _vsnprintf( s, 254, a, args_ptr);
#ifdef _WIN32
            writelog( s );
#else
	    OutputDebugString( s );
#endif
        } else {
#ifdef _WIN32
	    writelog( a );
#else
            OutputDebugString( a );  /* allows help text >255 chars */
#endif
        } 
    }

    Yield();
    return 0; 
}

#ifdef _WINDLL 
SHORTSIZ16 EXPORT
e1432_set_printf_window(HWND hwndText)
{
    diagHwndText = hwndText;
    return 0;
}
#endif /* _WINDL */

#endif
